import Utilities.waveform_creator as wc
import Utilities.gui_creator as gc
import Utilities.plot_creator as pc
import Utilities.nidaq_operations as no
import threading

channel_name = 'Dev1/ao0'
task = no.create_ao_task(channel_name)

label_x, label_y = 'Time (ms)', 'Voltage (V)'

root = gc.create_window(title='Waveform Generator',
                        size='1000x500')
control_box, right_frame = gc.create_frames(root)

var_num, var_samp_freq = gc.digitizing_control(control_box)
var_a, var_f, var_shape = gc.waveform_control(control_box)

ax, canvas = pc.create_plot(right_frame)
pc.update_plot(ax, canvas, [], [], label_x, label_y)

def generate_waveform():

    num, samp_freq = gc.get_dig_entries(var_num,
                                        var_samp_freq)
    a, f, shape = gc.get_wav_entries(var_a, var_f,
                                     var_shape)

    t = wc.create_time_data(num, samp_freq)
    y = wc.create_waveform_data(t, a, f, shape)

    pc.update_plot(ax, canvas, 1000*t, y, 
                   label_x, label_y, marker='o-')

    no.config_daq_timing(task, num, 'Continuous',
                         samp_freq)

    task.write(y, auto_start=True)

    return


def toggle():

    if btn.cget('text') == 'Start':
        btn.config(text='Stop')
        t = threading.Thread(target=generate_waveform)
        t.start()
    elif btn.cget('text') == 'Stop':
        btn.config(text='Start')
        task.stop()

    return


btn = gc.action_button(control_box, label='Start',
                       action=toggle)

root.mainloop()

task.close()
